/*
 * Decompiled with CFR 0.152.
 */
package com.arcazoid.util.hirestimer;

import com.arcazoid.common.Log;
import com.arcazoid.util.hirestimer.NativeTimer;

public class AdvancedTimer {
    private static long resolution;
    private static String[] hiresTimers;
    private long start = 0L;
    private long ticks = 0L;
    private boolean running = false;
    private static NativeTimer wintimer;

    public AdvancedTimer() {
        if (resolution == 0L) {
            AdvancedTimer.init();
        }
    }

    private static void init() {
        for (int i = 0; i < hiresTimers.length && !AdvancedTimer.getHiresTimer(hiresTimers[i]); ++i) {
        }
        if (wintimer == null) {
            long time;
            long prev_time = time = System.currentTimeMillis();
            while (time == prev_time) {
                time = System.currentTimeMillis();
            }
            resolution = time - prev_time;
            prev_time = time = System.currentTimeMillis();
            while (time == prev_time) {
                time = System.currentTimeMillis();
            }
            if (time - prev_time < resolution) {
                resolution = time - prev_time;
            }
            Log.log("Hires timer: Standard timer selected. (ticks per second=" + 1000L / resolution + ")");
        } else {
            Log.log("Hires timer: " + wintimer.getName() + " selected. (ticks per second=" + wintimer.getResolution() + ")");
        }
    }

    public static boolean getHiresTimer(String timer) {
        try {
            wintimer = (NativeTimer)Class.forName("com.arcazoid.util.hirestimer." + timer).newInstance();
            if (wintimer.available()) {
                resolution = 1L;
                return true;
            }
            wintimer = null;
            Log.log("Hires timer: " + wintimer.getName() + " not available");
        }
        catch (Throwable t) {
            wintimer = null;
            Log.log("AdvancedTimer.getHiresTimer(" + timer + "): " + t.toString());
        }
        return false;
    }

    public long getTime() {
        if (wintimer != null) {
            return wintimer.getClockTicks();
        }
        return System.currentTimeMillis();
    }

    public long getTimeElapsed() {
        if (this.running) {
            return (long)(1000.0f * ((float)this.getClockTicks() / (float)AdvancedTimer.getTicksPerSecond()));
        }
        return 0L;
    }

    public void start() {
        long time;
        long prev_time = time = this.getTime();
        this.ticks = 0L;
        this.running = true;
        while (time == prev_time) {
            time = this.getTime();
        }
        this.start = this.getTime();
    }

    public long getClockTicks() {
        if (this.running) {
            this.ticks = (this.getTime() - this.start) / resolution;
        }
        return this.ticks;
    }

    public void stop() {
        this.getClockTicks();
        this.running = false;
    }

    public void sleep() throws IllegalStateException {
        this.sleep(1L);
    }

    public void sleep(long ticks) throws IllegalStateException {
        long tick = this.getClockTicks();
        if (!this.running) {
            throw new IllegalStateException("Timer not running!");
        }
        while (this.getClockTicks() < tick + ticks) {
            Thread.yield();
        }
    }

    public void sleepUntil(long ticks) throws IllegalStateException {
        if (!this.running) {
            throw new IllegalStateException("Timer not running!");
        }
        while (this.getClockTicks() < ticks) {
            Thread.yield();
        }
    }

    public static long getResolution() {
        if (resolution == 0L) {
            AdvancedTimer.init();
        }
        return resolution;
    }

    public static long getTicksPerSecond() {
        if (resolution == 0L) {
            AdvancedTimer.init();
        }
        if (wintimer != null) {
            return wintimer.getResolution();
        }
        return 1000L / AdvancedTimer.getResolution();
    }

    static {
        hiresTimers = new String[]{"NanoTimer", "PerfTimer", "MsTimer"};
        wintimer = null;
    }
}

